#ifndef __SMManager_h__
#define __SMManager_h__


#include "SMIplImage.h"

#include <map>
#include <boost/interprocess/containers/string.hpp>
#include <boost/interprocess/containers/vector.hpp>
#include <boost/interprocess/containers/flat_map.hpp>
#include <boost/interprocess/containers/map.hpp>
#include <boost/interprocess/allocators/allocator.hpp>

#include <boost/interprocess/sync/interprocess_mutex.hpp>
#include <boost/interprocess/sync/interprocess_condition.hpp>






typedef boost::interprocess::managed_shared_memory::segment_manager                       
	TSegmentManager;
typedef boost::interprocess::allocator< void, TSegmentManager>                          
	TVoidAllocator;

typedef boost::interprocess::allocator< char, TSegmentManager>                          
	TCharAllocator;
typedef boost::interprocess::basic_string< char, std::char_traits< char>, TCharAllocator>   
	TCharString;
typedef boost::interprocess::allocator< TCharString, TSegmentManager>                          
	TCharStringAllocator;
typedef boost::interprocess::vector< TCharString, TCharStringAllocator>
	TStringVector;
typedef boost::interprocess::allocator< TStringVector, TSegmentManager>                 
	TStringVectorAllocator;


typedef boost::interprocess::allocator< int, TSegmentManager>                            
	TIntAllocator;
typedef boost::interprocess::vector< int, TIntAllocator>
	TIntVector;
typedef boost::interprocess::allocator< TIntVector, TSegmentManager>                 
	TIntVectorAllocator;
typedef boost::interprocess::vector< TIntVector, TIntVectorAllocator>
	TIntVectorVector;
typedef boost::interprocess::allocator< TIntVectorVector, TSegmentManager>                 
	TIntVectorVectorAllocator;


/**
	-
*/
class TSMManager{

	TVoidAllocator void_alloc;
   
	boost::interprocess::interprocess_mutex mutex;
   
	boost::interprocess::interprocess_condition  changeCondition;

	long long newestTimestamp;
	long long floatHistory;

	struct TUseImage
	{
		int usedCount;
		boost::interprocess::offset_ptr< TSMImage> imgPtr;


		TUseImage( const int count, const boost::interprocess::offset_ptr< TSMImage> _imgPtr)
			: usedCount( count), imgPtr( _imgPtr)
		{}
		TUseImage()
			: usedCount( 0), imgPtr( NULL)
		{}
	/*	TSMManager & operator=(const TSMManager& src);
		TSMManager(const TSMManager &src);*/
	};

	typedef std::pair< long long, TUseImage>
		TImageQueValue;
	typedef boost::interprocess::allocator< TImageQueValue, TSegmentManager>                    
		TImageQueValueAllocator;

	typedef boost::interprocess::map< long long, TUseImage, std::less< long long>, TImageQueValueAllocator>
		TImageQueue;
	typedef boost::interprocess::allocator< TImageQueue, TSegmentManager>                    
		TImageQueueAllocator;

	typedef boost::interprocess::vector< TImageQueue, TImageQueueAllocator>
		TImageQues;


	typedef boost::interprocess::allocator< int, TSegmentManager>                          
		TIntAllocator;
	typedef boost::interprocess::vector< int, TIntAllocator>
		TIntVector;


	typedef boost::interprocess::allocator< std::pair< TCharString, int>, TSegmentManager>                    
		TIDMapValueAllocator;
	typedef boost::interprocess::flat_map< TCharString, int, std::less< TCharString>, TIDMapValueAllocator>
		TIDMap;

	TImageQues imageQueues; 
	TIntVector queueRegisterCounts;
	TIDMap idMap;


	typedef boost::interprocess::allocator< float, TSegmentManager>                    
		TFloatAllocator;
	typedef boost::interprocess::vector< float, TFloatAllocator>
		TFloatVector;
	typedef std::pair< long long, TFloatVector>
		TFloatQueueValue;
	typedef boost::interprocess::allocator< TFloatQueueValue, TSegmentManager>                    
		TFloatQueueValueAllocator;
	typedef boost::interprocess::multimap< long long, TFloatVector, std::less< long long>,  TFloatQueueValueAllocator>
		TFloatQueue;
	typedef boost::interprocess::allocator< TFloatQueue, TSegmentManager>                    
		TFloatQueueAllocator;
	typedef boost::interprocess::vector< TFloatQueue, TFloatQueueAllocator>
		TFloatQueues;


	TFloatQueues floatQueues;
	TIntVector floatQueueRegisterCounts;
	TIDMap idFloatMap;

	void change();

	TSMManager & operator=(const TSMManager& src);
    TSMManager(const TSMManager &src);

public:

	TSMManager( const long long _floatHistory, TVoidAllocator voidAlloc);
	//: imageQueues( void_alloc), imageQueues( void_alloc)
	~TSMManager();

	void test();
		
		
	/* for images*/
	void pushImage( const std::string &queue, TSMImage *, const long long timestamp);

	long long getNewest( const std::string &queue);

	void registerImage( const std::string &queue, long long timestamp);
	IplImage * getImage( const std::string &queue, long long timestamp, const bool icreaseCounter = true);
	
	void returnImage( const std::string &queue, long long timestamp);

	void cleanup();

	void registerQueue( const std::string &queue);
	void deregisterQueue( const std::string &queue);
	void getActiveQueues( std::map< std::string, bool> &activeQueues);
		
	void waitForChange( const int ms = 0);

	long long getNewestTimestamp( ){ return newestTimestamp;}





	void registerFloatQueue( const std::string &queue);
	void deregisterFloatQueue( const std::string &queue);
	void getActiveFloatQueues( std::map< std::string, bool> &activeQueues);
	void push( const std::string &queueName, const std::vector< float> &, const long long);
	void get( const std::string &, const long long timestamp, std::vector< std::vector< float> > &res);	
	void getNewest( const std::string &, long long &timestamp, std::vector< std::vector< float> > &res);
	void getNewer( const std::string &, const long long timestamp, std::multimap< long long, std::vector< float> > &res);


};



#endif